


# Hands-On Linux Administration on Azure

<a href="https://www.packtpub.com/virtualization-and-cloud/hands-linux-administration-azure?utm_source=github&utm_medium=repository&utm_campaign=9781789130966"><img src="https://d255esdrn735hr.cloudfront.net/sites/default/files/imagecache/ppv4_main_book_cover/B10408_cover.png" alt="Hands-On Linux Administration on Azure" height="256px" align="right"></a>

This is the code repository for [Hands-On Linux Administration on Azure](https://www.packtpub.com/virtualization-and-cloud/hands-linux-administration-azure?utm_source=github&utm_medium=repository&utm_campaign=9781789130966), published by Packt.

**Learn to efficiently run Linux-based workloads in Azure**

## What is this book about?
Azure's market share has increased massively and enterprises are adopting it rapidly. Linux is a widely-used operating system and has proven to be one of the most popular workloads on Azure. It has become crucial for Linux administrators and Microsoft professionals to be well versed with the concepts of managing Linux workloads in an Azure environment.

This book covers the following exciting features:
* Understand why Azure is the ideal solution for your open source workloads 
* Master essential Linux skills and learn to find your way around the Linux environment 
* Deploy Linux in an Azure environment 
* Use configuration management to manage Linux in Azure 
* Manage containers in an Azure environment 


If you feel this book is for you, get your [copy](https://www.amazon.com/dp/1789130964) today!

<a href="https://www.packtpub.com/?utm_source=github&utm_medium=banner&utm_campaign=GitHubBanner"><img src="https://raw.githubusercontent.com/PacktPublishing/GitHub/master/GitHub.png" 
alt="https://www.packtpub.com/" border="5" /></a>

## Instructions and Navigations
All of the code is organized into folders. For example, Chapter02.

The code will look like the following:
```
[Mount] 
What = /dev/sdc1 
Where = /home/finance 
Type = xfs 
Options = defaults
```

**Following is what you need for this book:**
Hands-On Linux Administration on Azure is for Linux administrators and Microsoft professionals that need to deploy and manage their workloads in Azure. Prior knowledge of Linux and Azure isn't necessary.

With the following software and hardware list you can run all code files present in the book (Chapter 1-11).
### Software and Hardware List
| Chapter | Requirements | 
| --------| ------------------------------------ | 
| ALL | Azure subscription, Microsoft PowerShell, Azure CLI, Several Linux Distributions and opensource utilities available in their repositories  |  
| 4 | Azure Storage Explorer | 
| 6 | AADS | 
| 7 | Vagrant, Packer | 
| 8 | Ansible, SaltStack, PowerShell | 
| 9 | Rkt(Apache2 License), Docker | 
| 10 | VSCode (optional), MiniKube, Helm, Draft(MIT License) | 
| 11 | Log Analytics |  


We also provide a PDF file that has color images of the screenshots/diagrams used in this book. [Click here to download it](https://www.packtpub.com/sites/default/files/downloads/HandsOnLinuxAdministrationonAzure_ColorImages.pdf).

### Related products
* Learn PowerShell Core 6.0 [[Packt]](https://www.packtpub.com/networking-and-servers/learn-powershell-core-60?utm_source=github&utm_medium=repository&utm_campaign=9781788838986 ) [[Amazon]](https://www.amazon.com/dp/178883898X)

* Mastering Linux Shell Scripting - Second Edition [[Packt]](https://www.packtpub.com/virtualization-and-cloud/mastering-linux-shell-scripting-second-edition?utm_source=github&utm_medium=repository&utm_campaign=9781788990554 ) [[Amazon]](https://www.amazon.com/dp/1788990552)


## Get to Know the Author
**Frederik Vos**
, living in Purmerend, a city near Amsterdam in the Netherlands, works as a senior technical trainer of virtualization technologies, such as Citrix XenServer, and VMware vSphere. He specializes in data center infrastructures (hypervisor, network, and storage) and cloud computing (CloudStack, CloudPlatform, OpenStack, and Azure). He is also a Linux trainer and evangelist. He has a lot of knowledge as a teacher and also real-world experience as a system administrator. For the last three years he has been working as a freelance trainer and consultant within the ITGilde Cooperation, delivering many Linux training, such as Linux on Azure training for the Linux Foundation.


### Suggestions and Feedback
[Click here](https://docs.google.com/forms/d/e/1FAIpQLSdy7dATC6QmEL81FIUuymZ0Wy9vH1jHkvpY57OiMeKGqib_Ow/viewform) if you have any feedback or suggestions.


### Download a free PDF

 <i>If you have already purchased a print or Kindle version of this book, you can get a DRM-free PDF version at no cost.<br>Simply click on the link to claim your free PDF.</i>
<p align="center"> <a href="https://packt.link/free-ebook/9781839215520">https://packt.link/free-ebook/9781839215520 </a> </p>