


# Linux for Networking Professionals

<a href="https://www.packtpub.com/product/linux-for-networking-professionals/9781800202399?utm_source=github&utm_medium=repository&utm_campaign=9781800202399"><img src="https://static.packt-cdn.com/products/9781800202399/cover/smaller" alt="Linux for Networking Professionals" height="256px" align="right"></a>

This is the code repository for [Linux for Networking Professionals](https://www.packtpub.com/product/linux-for-networking-professionals/9781800202399?utm_source=github&utm_medium=repository&utm_campaign=9781800202399), published by Packt.

**Securely configure and operate Linux network services for the enterprise**

## What is this book about?
As Linux continues to gain prominence, there has been a rise in network services being deployed on Linux for cost and flexibility reasons. If you are a networking professional or an infrastructure engineer involved with networks, extensive knowledge of Linux networking is a must. 

This book covers the following exciting features:
* Use Linux as a troubleshooting and diagnostics platform
* Explore Linux-based network services
* Configure a Linux firewall and set it up for network services
* Deploy and configure Domain Name System (DNS) and Dynamic Host Configuration Protocol (DHCP) services securely
* Configure Linux for load balancing, authentication, and authorization services
* Use Linux as a logging platform for network monitoring
* Deploy and configure Intrusion Prevention Services (IPS)
* Set up Honeypot solutions to detect and foil attacks

If you feel this book is for you, get your [copy](https://www.amazon.com/dp/1800202393) today!

<a href="https://www.packtpub.com/?utm_source=github&utm_medium=banner&utm_campaign=GitHubBanner"><img src="https://raw.githubusercontent.com/PacktPublishing/GitHub/master/GitHub.png" 
alt="https://www.packtpub.com/" border="5" /></a>

## Instructions and Navigations
All of the code is organized into folders. For example, CH11.


**Following is what you need for this book:**

This book is for IT and Windows professionals and admins looking for guidance in managing Linux-based networks. Basic knowledge of networking is necessary to get started with this book.

With the following software and hardware list you can run all code files present in the book (Chapter 1-14).
### Software and Hardware List
| Chapter | Software required | OS required |
| -------- | ------------------------------------ | ----------------------------------- |
| 1-14 | Vmware/Virtualbox/Any virtualization software | Windows, Mac OS X, and Linux (Any) |
| 1-14 | Ubuntu Linux OS Version 20 or newer | Windows, Mac OS X, and Linux (Any) |

We also provide a PDF file that has color images of the screenshots/diagrams used in this book. [Click here to download it](http://www.packtpub.com/sites/default/files/downloads/9781800202399_ColorImages.pdf).

## Errata
* Page 55 (table, row 8, column 2): `tcp/443` _should be_`udp/514`

### Related products
* Mastering Linux Administration [[Packt]](https://www.packtpub.com/product/mastering-linux-administration/9781789954272?utm_source=github&utm_medium=repository&utm_campaign=9781789954272) [[Amazon]](https://www.amazon.com/dp/1789954274)

* Linux System Programming Techniques [[Packt]](https://www.packtpub.com/product/linux-system-programming-techniques/9781789951288?utm_source=github&utm_medium=repository&utm_campaign=9781789951288) [[Amazon]](https://www.amazon.com/dp/1789951283)

## Get to Know the Author
**Rob VandenBrink**
is a consultant with Coherent Security in Ontario, Canada. He is a volunteer with the Internet Storm Center, a site that posts daily blogs on information security and related stories. Rob also contributes as a volunteer to various security benchmarks at the Center for Internet Security, notably the Palo Alto Networks Firewall benchmark and the Cisco Nexus benchmark.
His areas of specialization include all facets of information security, network infrastructure, network and data center design, IT automation, orchestration, and virtualization. Rob has developed tools for ensuring policy compliance for VPN access users, a variety of networking tools native to Cisco IOS, as well as security audit/assessment tools for both Palo Alto Networks Firewall and VMware vSphere.
Rob has a master's degree in information security engineering from the SANS Technology Institute and holds a variety of SANS/GIAC, VMware, and Cisco certifications

### Download a free PDF

 <i>If you have already purchased a print or Kindle version of this book, you can get a DRM-free PDF version at no cost.<br>Simply click on the link to claim your free PDF.</i>
<p align="center"> <a href="https://packt.link/free-ebook/9781800202399">https://packt.link/free-ebook/9781800202399 </a> </p>