


# Red Hat Enterprise Linux 8 Administration

<a href="https://www.packtpub.com/product/red-hat-enterprise-linux-8-administration/9781800569829"><img src="https://static.packt-cdn.com/products/9781800569829/cover/smaller" alt="Book Name" height="256px" align="right"></a>

This is the code repository for [Red Hat Enterprise Linux 8 Administration](https://www.packtpub.com/product/red-hat-enterprise-linux-8-administration/9781800569829), published by Packt.

**Master Linux administration skills and prepare for the RHCSA certification exam**

## What is this book about?

Whether in infrastructure or development, as a DevOps or site reliability engineer, Linux skills are now more relevant than ever for any IT job, forming the foundation of understanding the most basic layer of your architecture. With Red Hat Enterprise Linux (RHEL) becoming the most popular choice for enterprises worldwide, achieving the Red Hat Certified System Administrator (RHCSA) certification will validate your Linux skills to install, configure, and troubleshoot applications and services on RHEL systems.

This book covers the following exciting features:

- Deploy RHEL 8 in different footprints, from bare metal and virtualized to the cloud
- Manage users and software on local and remote systems at scale
- Discover how to secure a system with SELinux, OpenSCAP, and firewalld
- Gain an overview of storage components with LVM, Stratis, and VDO
- Master remote administration with passwordless SSH and tunnels
- Understand the boot process, performance optimizations, and containers

If you feel this book is for you, get your [copy](https://s.admins.guru/buyonamazon) today!

<a href="https://www.packtpub.com/?utm_source=github&utm_medium=banner&utm_campaign=GitHubBanner"><img src="https://raw.githubusercontent.com/PacktPublishing/GitHub/master/GitHub.png" alt="https://www.packtpub.com/" border="5" /></a>

## Instructions and Navigations

All of the code is organized into folders. For example, Chapter05.

The code will look like the following:

```
[root@rhel8 ~]# useradd user01
[root@rhel8 ~]# grep user01 /etc/passwd
user01:x:1001:1001::/home/user01:/bin/bash
[root@rhel8 ~]# id user01
uid=1001(user01) gid=1001(user01) groups=1001(user01)

```

**Following is what you need for this book:**
This book is for IT professionals or students who want to start a career in Linux administration and anyone who wants to take the RHCSA 8 certification exam. Basic knowledge of Linux and familiarity with the Linux command-line is necessary.

With the following software and hardware list you can run all code files present in the book (Chapter 1-19).

### Software and Hardware List

| Chapter | Software required                           | OS required                        |
| ------- | ------------------------------------------- | ---------------------------------- |
| 1-19    | Red Hat Enterprise Linux 8                  | Windows, Mac OS X, and Linux (Any) |
| 1-19    | Oracle VM VirtualBox or Any Virtual Machine | Windows, Mac OS X, and Linux (Any) |

We also provide a PDF file that has color images of the screenshots/diagrams used in this book. [Click here to download it](https://static.packt-cdn.com/downloads/9781800569829_ColorImages.pdf).

### Related products <Other books you may enjoy>

- Linux Kernel Programming[[Packt]](https://www.packtpub.com/product/linux-kernel-programming/9781789953435) [[Amazon]](https://www.amazon.com/Linux-Kernel-Development-Cookbook-programming-ebook/dp/B07RW915K4)

- Mastering Embedded Linux Programming - Third Edition [[Packt]](https://www.packtpub.com/product/mastering-embedded-linux-programming-third-edition/9781789530384) [[Amazon]](https://www.amazon.com/Mastering-Embedded-Linux-Programming-potential-ebook/dp/B07LH35XLK)

## Errata
* Page 305 Under (Using SELinux Boolean settings to enable services): **getsebol -a|grep ^http** _should be_ **getsebool -a|grep ^http**

## Get to Know the Authors

**Miguel Pérez Colino**
He is an experienced IT enthusiast with a clear orientation towards open source software and open standards. He has an extensive background in IT, from operations to the architecture of large deployments and from identifying and prototyping solutions to defining IT strategies. He has delivered large projects, including NATO interoperable command and control systems in defense, extensive large deployments in retail (>15,000 devices), and digital transformation in the finance sector. Now, as part of the Cloud Platforms Business Unit of Red Hat, he works as a senior principal product manager building tools and defining methodologies to ease modernization and migration for customers, enabling the use of open source.

**Pablo Iranzo Gómez**
He is a software engineer whose Linux exposure began while studying physics, a period during which he was also involved in LUGs and some projects related to HPC clusters and system administration and consultancy.Currently, he is a senior software engineer in Red Hat's SolEng department, focusing on OpenShift, with experience in consulting, cloud technical account management, OpenStack software maintenance in industries such as hospitality, retail, airlines, government, telco, 5G, partners, IT covering system administration and automation, virtualization, PaaS, support, the cloud, and so on, having a broad understanding of different views, needs, and risks across the industry.

**Scott McCarty**
He is a principal product manager for the container subsystem team, which enables key product capabilities in OpenShift Container Platform and Red Hat Enterprise Linux. His focus areas include container runtimes, tools, and images.Scott is a social media start-up veteran, an e-commerce old-timer, and a weathered government research technologist, with experience across a variety of companies and organizations, from seven-person start-ups to 15,000-employee technology companies. This has culminated in a unique perspective on open source software development, delivery, and maintenance.
### Download a free PDF

 <i>If you have already purchased a print or Kindle version of this book, you can get a DRM-free PDF version at no cost.<br>Simply click on the link to claim your free PDF.</i>
<p align="center"> <a href="https://packt.link/free-ebook/9781800569829">https://packt.link/free-ebook/9781800569829 </a> </p>
