


# Windows Subsystem for Linux 2 (WSL 2) - Tips, Tricks, and Techniques

<a href="https://www.packtpub.com/cloud-networking/windows-subsystem-for-linux-2-wsl-2-tips-tricks-and-techniques?utm_source=github&utm_medium=repository&utm_campaign=9781800562448"><img src="https://static.packt-cdn.com/products/9781800562448/cover/smaller" alt="Windows Subsystem for Linux 2 (WSL 2) - Tips, Tricks, and Techniques" height="256px" align="right"></a>

This is the code repository for [Windows Subsystem for Linux 2 (WSL 2) - Tips, Tricks, and Techniques](https://www.packtpub.com/cloud-networking/windows-subsystem-for-linux-2-wsl-2-tips-tricks-and-techniques?utm_source=github&utm_medium=repository&utm_campaign=9781800562448), published by Packt.

**Maximise productivity of your Windows 10 development machine with custom workflows and configurations**

## What is this book about?
Windows Subsystem for Linux (WSL) allows you to run native Linux tools alongside traditional Windows applications. Whether you’re developing applications across multiple operating systems or just want to bring more tools into your Windows environment, WSL offers endless possibilities and seamless interoperability. This book will help you learn about the Windows Subsystem for Linux and how to use it effectively through a hands-on approach. 

This book covers the following exciting features:
* Install and configure Windows Subsystem for Linux and Linux distros
* Access web applications running in Linux from Windows
* Invoke Windows applications, file systems, and environment variables from bash in WSL
* Customize the appearance and behavior of the Windows Terminal to suit your preferences and workflows
* Explore various tips for enhancing the Visual Studio Code experience with WSL
* Install and work with Docker and Kubernetes within Windows Subsystem for Linux
* Discover various productivity tips for working with Command-line tools in WSL

If you feel this book is for you, get your [copy](https://www.amazon.com/dp/1800562446) today!

<a href="https://www.packtpub.com/?utm_source=github&utm_medium=banner&utm_campaign=GitHubBanner"><img src="https://raw.githubusercontent.com/PacktPublishing/GitHub/master/GitHub.png" 
alt="https://www.packtpub.com/" border="5" /></a>

## Instructions and Navigations
All of the code is organized into folders. For example, Chapter02.

The code will look like the following:
```
"profiles": {
"defaults": {
"fontFace": "Cascadia Mono PL"
},
```

**Following is what you need for this book:**
This book is for developers who want to use Linux tools on Windows, including Windows-native programmers looking to ease into a Linux environment based on project requirements or Linux developers who've recently switched to Windows. This book is also for web developers working on open source projects with Linux-first tools such as Ruby or Python, or developers looking to switch between containers and development machines for testing apps. Prior programming or development experience and a basic understanding of running tasks in bash, PowerShell, or the Windows Command Prompt will be required.

With the following software and hardware list you can run all code files present in the book (Chapter 1-11).
### Software and Hardware List
| Chapter | Software required | OS required |
| -------- | ------------------------------------ | ----------------------------------- |
| 1 - 11 | Docker Desktop | Windows 10 version 2004 build 19041 |
| 1 - 11 | Visual Studio Code | Windows 10 version 2004 build 19041 |

We also provide a PDF file that has color images of the screenshots/diagrams used in this book. [Click here to download it](https://static.packt-cdn.com/downloads/9781800562448_ColorImages.pdf).

### Related products
* Learning Microsoft Project 2019 [[Packt]](https://www.packtpub.com/product/learning-microsoft-project-2019/9781838988722?utm_source=github&utm_medium=repository&utm_campaign=9781838988722) [[Amazon]](https://www.amazon.com/dp/1838988726)

* Workflow Automation with Microsoft Power Automate [[Packt]](https://www.packtpub.com/product/workflow-automation-with-microsoft-power-automate/9781839213793?utm_source=github&utm_medium=repository&utm_campaign=9781839213793) [[Amazon]](https://www.amazon.com/dp/1839213795)

## Get to Know the Author
**Stuart Leeks**
is a principal software development engineer at Microsoft. He has worked with a wide range of customers, from small ISVs to large enterprises, to help them be successful building with the Microsoft technology stack. While Stuart has experience with a diverse set of technologies, he is most passionate about the web and the cloud.
Stuart is a web geek, lover of containers, cloud fanatic, feminist, performance and scalability enthusiast, father of three, husband, and a salsa dancer and teacher, and loves bad puns. He has been writing code since the days of the BBC Micro and still gets a kick out of it.
### Download a free PDF

 <i>If you have already purchased a print or Kindle version of this book, you can get a DRM-free PDF version at no cost.<br>Simply click on the link to claim your free PDF.</i>
<p align="center"> <a href="https://packt.link/free-ebook/9781800562448">https://packt.link/free-ebook/9781800562448 </a> </p>