<?
// file: sitemap.php
// purpose: display a map of entire site structure

// From which parent directory should the sitemap begin?
$beg_path = "C:\Program Files\Apache Group\Apache\htdocs\phprecipes";

// What Is the location of the folder graphic?
// This path should be *relative* to the Apache server root directory
$folder_location = "C:\My Documents\PHP for Programmers\FINAL CHPS\graphics\folder.gif";

// What should be displayed in the sitemap title bar?
$page_name = "PHPRecipes SiteMap";

// Will this script be used on a Linux or Windows server? (0 for Windows; 1 for Linux)
$using_linux = 0;
// function: display_directory
// purpose: Parses a directory specified by $dir1 and formats directory and file structure. 
// This function is recursively called.

function display_directory($dir1, $folder_location, $using_linux, $init_depth) {

// update the directory path
$dir .= $dir1;
$dh = opendir($dir);
 
while ($file = readdir($dh)) :
     // do not display the "." and ".."in each directory.
     if ( ($file != ".") && ($file != "..") ) :

          if ( $using_linux == 0 ) :
               $depth = explode("\\", $dir);
          else :
               $depth = explode("/", $dir);
          endif;
          $current_depth = sizeof($depth);

          // Build path In accordance with what OS Is being used.
          if ($using_linux == 0) :
               $tab_depth = $current_depth - $init_depth;	
               $file = $dir."\\".$file;
          else :
               $file = $dir."/".$file;
          endif;

          // Is $file a directory?
          if ( is_dir($file) ) :
               $x = 0;
               // calculate tab depth
               while ( $x < ($tab_depth * 2) ) :
                    print "&nbsp;";
                    $x++;
              endwhile;

               print "<img src=\"$folder_location\" alt=\"[dir]\"> ".basename($file)."<br>";
               // Increment the &nbsp; count
  
               // Recursive call to display_directory() function
              display_directory($file, $folder_location, $using_linux, $init_depth);

          // Not dealing with a directory
          else :
               // Build path In accordance with what OS Is being used.
               if ($using_linux == 0) :
                    $tab_depth = ($current_depth - $init_depth) - 2;				
                    $x = 0;
                    // calculate tab depth
                    while ( $x < (($tab_depth * 2) + 5) ) :
                         print "&nbsp;";
                         $x++;
                    endwhile;
                    print "<a href = \"".$dir."\\".basename($file)."\">".basename($file)."</a> <br>";
               else :
                    print "<a href = \"".$dir."/".basename($file)."\">".basename($file)."</a> <br>";
               endif;

          endif; // Is_dir(file)
     endif; // If ! "." or ".."

endwhile;

// close the directory
closedir($dh);
}
?>
<html>
<head>
<title> <? print "$page_name"; ?> </title>
</head>
<body bgcolor="#ffffff" text="#000000" link="#000000" vlink="#000000" alink="#000000">
<?
// calculate Initial tab depth
if ($using_linux == 0) :
         $depth = explode("\\", $beg_path);
else :
    $depth = explode("/", $beg_path);
endif;
$init_depth = sizeof($depth);
display_directory($beg_path, $folder_location, $using_linux, $init_depth);
?>
</body>
</html>
