<?
/*
File: sniffer.php
Purpose: Determines browser type / version and platform information
Author: WJ Gilmore
Date: August 24, 2000
*/

// Function: browser_info
// Purpose: Returns browser type and version

function browser_info ($agent) {
     // Determine browser type
     //  Search for Internet Explorer signature. 
     if (ereg( 'MSIE ([0-9].[0-9]{1,2})', $agent, $version)) :
          $browse_type = "IE";
          $browse_version = $version[1];

     //  Search for Opera signature. 
     elseif (ereg( 'Opera ([0-9].[0-9]{1,2})', $agent, $version)) :
          $browse_type = "Opera";
          $browse_version = $version[1];

     //  Search for Netscape signature. The search for the Netscape browser
     //  *must* take place after the search for the Internet Explorer and Opera
     //  browsers, because each likes to call itself
     //  Mozilla as well as by its actual name.
     elseif (ereg( 'Mozilla/([0-9].[0-9]{1,2})', $agent, $version)) :
          $browse_type = "Netscape";
          $browse_version = $version[1];

     // If not Internet Explorer, Oper,a or Netscape, then call it unknown.
     else :
          $browse_type = "Unknown";
          $browse_version = "Unknown";

     endif;

     // return the browser type and version as array
     return array($browse_type, $browse_version);

} // end browser_info

// Function: opsys_info
// Purpose: Returns the user operating system

function opsys_info($agent) {
     // Determine operating system
     // Search for Windows platform
     if ( strstr ($agent, 'Win') ) :
          $opsys = "Windows";

     // Search for Linux platform
     elseif ( strstr($agent, 'Linux') ) :
          $opsys = "Linux";

     // Search for UNIX platform
     elseif ( strstr ($agent, 'Unix') ) :
          $opsys = "Unix";

     // Search for Macintosh platform
     elseif ( strstr ($agent,'Mac') ) :
          $opsys = "Macintosh";

     // Platform is unknown
     else :
          $opsys = "Unknown";

     endif;

     // return the operating system
     return $opsys;

} // end opsys_info

// receive returned array as a list

list ($browse_type, $browse_version) = browser_info ($HTTP_USER_AGENT);
$operating_sys = opsys_info ($HTTP_USER_AGENT);

print "Browser Type: $browse_type <br>";
print "Browser Version: $browse_version <br>";
print "Operating System: $operating_sys <br>";

?>