<?
class template {

VAR $files = array();
VAR $variables = array();
VAR $opening_escape = '{';
VAR $closing_escape = '}';

// Function: register_file()
// Purpose: Store contents of file specified by $file_id

function register_file($file_id, $file_name) {

     // Open $file_name for reading, or exit and print an error message.
     $fh = fopen($file_name, "r") or die("Couldn't open $file_name!");

     // Read in the entire contents of $file_name.
     $file_contents = fread($fh, filesize($file_name));

     // Assign these contents to a position in the array. This position is denoted by the key $file_id
     $this->files[$file_id] = $file_contents;

     // We're finished with the file, so close it.
     fclose($fh);
} // end register_file;

// Function: register_variables()
// Purpose: Store variables passed in via $variable_name under the corresponding
// array key, specified by $file_id

function register_variables($file_id, $variable_name) {

     // attempt to create array from passed in variable names
     $input_variables = explode(",", $variable_name);

     // assign variable name to next position in $file_id array
     while (list(,$value) = each($input_variables)) :

          // assign the value to a new position in the $this->variables array
          $this->variables[$file_id][] = $value;		

     endwhile;			

} // end register_variables

// Function: file_parser()
// Purpose: Parse all registered variables found within file contents 
//                 specified by input parameter $file_id

function file_parser($file_id) {

     // How many variables are registered for this particular file?
     $varcount = count($this->variables[$file_id]);

     // How many files are registered?
     $keys = array_keys($this->files);

     // If the $file_id exists in the $this->files array and it has some registered variables
     if ( (in_array($file_id, $keys)) && ($varcount > 0) ) :

          // reset $x
          $x = 0;

          // while there are still variables to parse
          while ($x < sizeof($this->variables[$file_id])) :

               // retrieve the next variable
               $string = $this->variables[$file_id][$x];
               
               // retrieve this variable value! Notice that I'm using a variable variable to retrieve this value.
               // this value will be substituted into the file contents, taking the place of the corresponding variable 
               // name.
               GLOBAL $$string;

               // What exactly is to be replaced within the file contents?
               $needle = $this->opening_escape.$string.$this->closing_escape;

               // Perform the string replacement.
               $this->files[$file_id] = str_replace(
                                                  $needle,   // needle
                                                  $$string,   // string
                                                  $this->files[$file_id]); // haystack
               // increment $x
               $x++;
          endwhile;
     endif;
} // end file_parser

// Function: print_file()
// Purpose: Print out the file contents specified by input parameter $file_Id

function print_file($file_id) {
     // print out the contents pointed to by $file_id     
     print $this->files[$file_id];
}

} // END template.class