# Further Reading
*For the book "Linux Kernel Programming", Kaiwan N Billimoria, Packt (Mar 2021).*

*Book GitHub repo*: https://github.com/PacktPublishing/Linux-Kernel-Programming

Here, we present, in a chapter-wise format, additional online as well as book references. We feel that these will help you, the reader, in digging deeper into topics, or gaining additional views/information, or both. We definitely recommend you browse through the provided references. Also, you will find that some resources are repeated across chapters; we leave it this way so that you can gain all required resources in one place (and chapter-wise).
(Obviously, these reference articles/blogs/etc are provided "as-is"; we cannot vouch for their correctness or validity).

For your convenience, below are chapter-wise links to the *Further Reading* notes:

- [**Generic online and book resources : miscellaneous, very useful**](https://github.com/PacktPublishing/Linux-Kernel-Programming/blob/master/Further_Reading.md#generic-online-and-book-resources--miscellaneous-very-useful)

 - [Chapter 1, Kernel workspace setup](https://github.com/PacktPublishing/Linux-Kernel-Programming/blob/master/Further_Reading.md#chapter-1-kernel-development-workspace-setup---further-reading)
 - [Chapter 2, Building the Kernel From Source, Part 1](https://github.com/PacktPublishing/Linux-Kernel-Programming/blob/master/Further_Reading.md#chapter-2-building-the-linux-kernel-from-source---further-reading)
 - [Chapter 3, Building the 5.0 Linux kernel from Source, Part 2](https://github.com/PacktPublishing/Linux-Kernel-Programming/blob/master/Further_Reading.md#chapter-3-building-the-linux-kernel-from-source---further-reading)
 - [Chapter 4, Writing your first Kernel Module - the LKM Framework, Part 1](https://github.com/PacktPublishing/Linux-Kernel-Programming/blob/master/Further_Reading.md#chapter-4-writing-your-first-kernel-module-lkms-part-1---further-reading)
 - [Chapter 5, Writing your first Kernel Module - the LKM Framework, Part 2](https://github.com/PacktPublishing/Linux-Kernel-Programming/blob/master/Further_Reading.md#chapter-5-writing-your-first-kernel-module-lkms-part-2---further-reading)
 - [Chapter 6, Kernel Internals Essentials - Processes and Threads](https://github.com/PacktPublishing/Linux-Kernel-Programming/blob/master/Further_Reading.md#chapter-6-kernel-internals-essentials---processes-and-threads---further-reading)
 - [Chapter 7, Memory Management Internals Essentials](https://github.com/PacktPublishing/Linux-Kernel-Programming/blob/master/Further_Reading.md#chapter-7-memory-management-internals-essentials---further-reading)
 - [Chapter 8, Kernel Memory Allocation for Module Authors, Part 1](https://github.com/PacktPublishing/Linux-Kernel-Programming/blob/master/Further_Reading.md#chapter-8-kernel-memory-allocation-for-module-authors-part-1---further-reading)
 - [Chapter 9, Kernel Memory Allocation for Module Authors, Part 2](https://github.com/PacktPublishing/Linux-Kernel-Programming/blob/master/Further_Reading.md#chapter-9-kernel-memory-allocation-for-module-authors-part-2---further-reading)
 - [Chapter 10, The CPU Scheduler, Part 1](https://github.com/PacktPublishing/Linux-Kernel-Programming/blob/master/Further_Reading.md#chapter-10-the-cpu-scheduler-part-1---further-reading)
 - [Chapter 11, The CPU Scheduler, Part 2](https://github.com/PacktPublishing/Linux-Kernel-Programming/blob/master/Further_Reading.md#chapter-11-the-cpu-scheduler-part-2---further-reading)
 - [Chapter 12, Kernel Synchronization, Part 1](https://github.com/PacktPublishing/Linux-Kernel-Programming/blob/master/Further_Reading.md#chapter-12-kernel-synchronization-part-1---further-reading)
 - [Chapter 13, Kernel Synchronization, Part 2](https://github.com/PacktPublishing/Linux-Kernel-Programming/blob/master/Further_Reading.md#chapter-13-kernel-synchronization-part-2---further-reading)


**Don't forget**: The companion book *'Linux Kernel Programming (Part 2): Writing character device drivers: Learn to work with user-kernel interfaces, handle peripheral I/O & hardware interrupts'* is available as well! *(Hey, the ebook is free!)*
    - It's [opensource GitHub repo is here.](https://github.com/PacktPublishing/Linux-Kernel-Programming-Part-2)

<br>


Besides the *Further Reading* resource specified chapter-wise, be sure to refer to the "special" section below entitled **Generic online and book resources : miscellaneous, very useful**! These
links and books are considered to be useful throughout your journey through this book and after.
<br>

## Generic online and book resources : miscellaneous, very useful

- [The Linux kernel documentation](https://www.kernel.org/doc/html/latest/#the-linux-kernel-documentation)
- Very useful! [LWN (Linux weekly news) Kernel index](https://lwn.net/Kernel/Index/)
- Deprecated things: DON'T use 'em! Just say No; [Deprecated Interfaces, Language Features, Attributes, and Conventions](https://www.kernel.org/doc/html/latest/process/deprecated.html#deprecated-interfaces-language-features-attributes-and-conventions)

A few excellent books that come to mind (specific books on the Linux kernel and writing Linux device drivers are mentioned in the appropriate chapter's *Further reading* section):

- The Mythical Man Month, Frederick P Brooks
- The Art of Unix Programming, Eric S Raymond (AW)
- Programming Pearls, Jon Bentley
- The Practice of Programming, Brian Kernighan and Rob Pike
- The Pragmatic Programmer: From Journeyman to Master, Hunt and Thomas
- The Joy of Linux, Hall and Proffitt
- Hands-On System Programming with Linux, Kaiwan N Billimoria
- Unix Network Programming, W. Richard Stevens
- Unix Systems Programming: Communication, Concurrency and Threads, Robbins and Robbins
- [Secure Programming for Linux and Unix HOWTO, David Wheeler](https://www.tldp.org/HOWTO/pdf/Secure-Programs-HOWTO.pdf)

- In general an excellent in-depth technical article: [SO YOU WANT TO BUILD AN EMBEDDED LINUX SYSTEM?, Jay Carlson, Oct 2020](https://jaycarlson.net/embedded-linux/) ; it covers an introduction to the whys
and why-nots of using Linux on an embedded system, hardware and software design workflow, as well as a pretty detailed rundown on 10 CPUs/boards that run embedded Linux (with benchmarks)
- Julia Evans' blog and zines:
    - ['You can be a kernel hacker!', Julia Evans](https://jvns.ca/blog/2014/09/18/you-can-be-a-kernel-hacker/)
    - [Blog](https://jvns.ca/)
    - [Zines](https://wizardzines.com/)

- [Lowlevel programming University, gurugio](https://github.com/gurugio/lowlevelprogramming-university)

- *Tip (reprodcued from Chapter 5)*: 
"Is there a really practical hands-on tip, an almost guaranteed way to become a kernel hacker? Of course, keep reading this book! Ha ha, yes, besides, do partake in the [simply awesome Eudyptula Challenge](http://www.eudyptula-challenge.org/). Hang on, it's - very unfortuantely, and as of this writing - closed down.
Fear not, [here's a site with all the challenges](https://github.com/agelastic/eudyptula) posted (and the solutions, don't cheat!); do check it out and try the challenges."



<br>

## Chapter 1, Kernel Development Workspace Setup - Further Reading

Resources on setting up a Linux guest using VirtualBox on a Windows host:

- A very clearly written tutorial entitled [Install Linux Inside Windows
Using VirtualBox, Abhishek Prakash (It's FOSS!, August 2019)](https://itsfoss.com/install-linux-in-virtualbox/)

- An alternate, similarly excellent resource: [Install Ubuntu on Oracle
VirtualBox](https://brb.nci.nih.gov/seqtools/installUbuntu.html)

- [How to Install VirtualBox Guest Additions in Ubuntu](https://www.tecmint.com/install-virtualbox-guest-additions-in-ubuntu/)
- Related – [Easy Ways to Check If Your Processor Supports Virtualization](https://www.technorms.com/8208/check-if-processorsupports-virtualization)

- ['Share Folders between Host and Guest OS in VirtualBox', S Butler, April 2020](https://helpdeskgeek.com/virtualization/virtualbox-share-folder-host-guest/)
- [Emulating Raspberry Pi on Linux](http://embedonix.com/articles/linux/emulating-raspberry-pi-on-linux/)

Good resources on toolchains:

- [Cross-compilation toolchains for Linux, Bootlin](https://toolchains.bootlin.com/)
Very user-friendly – simply select and download the toolchain of choice.

- [Toolchains on eLinux](https://elinux.org/Toolchains)

- A wiki page (from the SEALS project I maintain, see the following) with instructions on downloading and installing the latest ARM Linaro toolchain (a popular one) is available [here](https://github.com/kaiwan/seals/wiki/HOWTO-Install-required-packages-on-the-Host-for-SEALS)

- Learn how to install many apps on Ubuntu/CentOS/Debian/etc via the [Installi web guide](https://installati.one/)

Some useful tooling, drivers, and so on, created by myself:

- The *procmap* utility - view any process's virtual address space fully (both user+kernel VAS): [procmap](https://github.com/kaiwan/procmap)
- Scripts, tools, utils, code : [usefulsnips](https://github.com/kaiwan/usefulsnips)
- [SEALS](https://github.com/kaiwan/seals) : Simple Embedded Arm Linux System
- [device-memory-readwrite](https://github.com/kaiwan/device-memory-readwrite) : Read/write pretty much any memory location (RAM or hardware IO memory) on a device or PC

Emulating a Raspberry Pi:
    - [Emulating a Raspberry Pi on Linux](http://embedonix.com/articles/linux/emulating-raspberry-pi-on-linux/)

- [qemu-rpi-kernel, GitHub](https://github.com/dhruvvyas90/qemu-rpi-kernel/wiki)

Code browsers
    - [Ctags Tutorial](https://courses.cs.washington.edu/courses/cse451/10au/tutorials/tutorial_ctags.html)
    - [The Vim/Cscope tutorial](http://cscope.sourceforge.net/cscope_vim_tutorial.html)

<br>

## Chapter 2, Building the Linux Kernel From Source - Further Reading

- **[Official Kernel Documentation](https://www.kernel.org/doc/html/latest/index.html)** : the modern Linux kernel documentation is very well written and presented here
	- ["2. How the development process works"](https://www.kernel.org/doc/html/latest/process/2.Process.html#how-the-development-process-works)
	- [The Linux kernel build system - kbuild - infrastructure](https://www.kernel.org/doc/Documentation/kbuild/)

- Git
    - [Firstly, A Gentle Introduction to Version Control](http://chronicle.com/blogs/profhacker/a-gentle-introduction-to-version-control/23064)
    - [Resources to Learn Git](http://try.github.io/)
    - [The “official” git website](http://git-scm.com/)
    - [Try Git in your browser – interactive tutorial!](https://try.github.io/levels/1/challenges/1)
    - [Most commonly used git tips and tricks on github](https://github.com/git-tips/tips)
    - [The "Git Magic" book, by Ben Lynn (PDF)](http://www-cs-students.stanford.edu/~blynn/gitmagic/book.pdf)
    - [Aha! Moments when learning Git](http://betterexplained.com/articles/aha-moments-when-learning-git/)
    - [How not to be afraid of Git anymore](https://medium.freecodecamp.org/how-not-to-be-afraid-of-git-anymore-fe1da7415286)
    - [Getting Git Right, Atlassian.com](https://www.atlassian.com/git/) 
    - [... and many more](https://www.google.com/search?q=learning+to+use+git)

- [Linux Kernel Release Model, Greg Kroah-Hartman, Feb 2018](http://kroah.com/log/blog/2018/02/05/linux-kernel-release-model/)
- [Civil Infrastructure Platform Announces New Super Long Term Support Kernel that Advances Automation, Machine Learning and Artificial Intelligence, LF, Feb 2019](https://www.linuxfoundation.org/press-release/2019/02/civil-infrastructure-platform-announces-new-super-long-term-support-kernel-that-advances-automation-machine-learning-and-artificial-intelligence/)
- [LTSI Project update - Long Term Support Initiative – slide deck, Open Source Summit Japan, June 2018](https://events19.linuxfoundation.org/wpcontent/uploads/2017/11/Using-Linux-for-Long-Term-Community-Status-and-the-Way-We-Go-OSS-Tsugikazu-Shibata.pdf)

    - [Working with the kernel development community](https://www.kernel.org/doc/html/latest/process/index.html#working-with-the-kernel-development-community)
    - Blog artcile: ['Kernel Patch Submission tutorial', Saurabh Singh Sengar](https://saurabhsengarblog.wordpress.com/2015/11/26/kernel-patch-submission-tutorial/)
    - [Working with linux-next](https://www.kernel.org/doc/man-pages/linux-next.html)

- [Linux kernel versions with detailed notes on new features, kernelnewbies](https://kernelnewbies.org/LinuxVersions)
- Fun: [Occurences of words in the Linux kernel source code over time](https://www.vidarholen.net/contents/wordcount/#hack*,workaround*,todo,fixme)

- Licensing
	-   [The differences between the GPL, LGPL and the BSD](https://fosswire.com/post/2007/04/the-differences-between-the-gpl-lgpl-and-the-bsd/)
	- [Proprietary loadable kernel modules, LWN](https://lwn.net/Articles/434491/)
	- [Choose an open source license](https://choosealicense.com/)
	- [Legal Risks of Open Source – GPL/Linux Loadable Kernel Modules](http://sourceauditor.com/blog/legal-risks-of-open-source-gpllinux-loadable-kernel-modules/)
	- [Linux kernel licensing rules](https://www.kernel.org/doc/html/latest/process/license-rules.html#linux-kernel-licensing-rules)
	- To circumvent the EXPORT_SYMBOL_GPL(), people have been known to use a GPL "shim" kernel module whose routines are invoked from a proprietary module; [Greg K Hartman 'Re: EXPORT_SYMBOL_GPL recursive for shim and/or wrapper](http://linux-kernel.2935.n7.nabble.com/EXPORT-SYMBOL-GPL-recursive-for-shim-and-or-wrappers-tp474689p474690.html)
	- [MIT vs. BSD vs. Dual License](https://softwareengineering.stackexchange.com/questions/121998/mit-vs-bsd-vs-dual-license)

- [Configuring the kernel](https://www.kernel.org/doc/html/latest/admin-guide/README.html#configuring-the-kernel)
- Detailed article: [Exploring the Linux kernel: The secrets of Kconfig/kbuild](https://opensource.com/article/18/10/kbuild-and-kconfig)
- Article: [How to compile a Linux kernel in the 21st century, S Kenlon, Aug 2019](https://opensource.com/article/19/8/linux-kernel-21st-century)
- Interesting: [Meet the contributor of the 1-millionth commit: Ricardo Neri, Swapnil Bharatiya, Sept 2020](https://www.linux.com/featured/meet-the-one-millionth-committer-to-linux-ricardo-neri/)

<br>

## Chapter 3, Building the Linux Kernel From Source - Further Reading

- Initramfs (initrd):
    - [Opening and modifying the initrd](http://www.alexonlinux.com/opening-and-modifying-the-initrd)
    - [Initramfs (on Ubuntu wiki)](https://wiki.ubuntu.com/Initramfs)
    - informative: [debian bug report: intel-microcode: breaks initrd for newer kernels, Sept 2014](https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=760765)
    - [distri: 20x faster initramfs (initrd) from scratch, Jan 2020](https://michael.stapelberg.ch/posts/2020-01-21-initramfs-from-scratch-golang/)
    - Encrypting disks with LUKS and cryptsetup
        - ['How To: Linux Hard Disk Encryption With LUKS (cryptsetup Command), Sept 2017, nixCraft](https://www.cyberciti.biz/hardware/howto-linux-hard-disk-encryption-with-luks-cryptsetup-command/)
        - ['Basic Guide To Encrypting Linux Partitions With LUKS', Oct 2016, Nick Congleton](https://linuxconfig.org/basic-guide-to-encrypting-linux-partitions-with-luks)
        - RedHat-specific: ['What is LUKS disk encryption and how can it be implemented?', Oct 2019, RedHat](https://access.redhat.com/solutions/100463)


- [GRUB: How do I change the default boot kernel](https://askubuntu.com/questions/216398/set-older-kernel-as-default-grub-entry)
- [How to Boot into Single User Mode in CentOS/RHEL 7, Kili, Tecmint, August 2017](https://www.tecmint. com/bootinto-single-user-mode-in-centos-7/)
- Article: [Linux Kernel Cross Compilation](https://gts3.org/2017/cross-kernel.html)
- [SEALS - Simple Embedded ARM Linux System - project](https://github.com/kaiwan/seals)
	- - [Wiki pages](https://github.com/kaiwan/seals/wiki)
- Building the (usual 32-bit) kernel for the Raspberry Pi device
    - [Raspberry Pi kernel build: official doc](https://www.raspberrypi.org/documentation/linux/kernel/building.md)
    - Building a **64-bit** kernel for the Raspberry Pi

        - blog article: ['BUILD A 64-BIT KERNEL FOR YOUR RASPBERRY PI 3', Dec 2016](https://devsidestory.com/build-a-64-bit-kernel-for-your-raspberry-pi-3/)
  
        - blog article: ['Tutorial: How (and why!) to set up a 64-bit kernel, 32-bit Raspbian host OS, 64-bit nspawn Debian guest OS RPi3 system', Jan 2019](https://www.raspberrypi.org/forums/viewtopic.php?f=56&t=232415&sid=146ea82cef8d235c1eaf64a12a8c3427)
        - On GitHub: ['Bootable RPi3 image with 64-bit kernel, 32-bit Raspbian Stretch host OS, 64-bit Debian Buster guest OS in nspawn container', Sakaki, Apr 2019](https://github.com/sakaki-/raspbian-nspawn-64)
        - Interesting, an [Ubuntu 18.04 server on Aarch64 Raspberry Pi](https://wiki.ubuntu.com/ARM/RaspberryPi); simplest way to get a 64-bit Raspberry Pi kernel and rootfs in a single image which can be burned onto the SD card

- New Linux kernel: ['Linux 5.6 Is Looking Like It Will Be Spectacular With A Long List Of Features', Phoronix, 26Jan2020](https://www.phoronix.com/scan.php?page=news_item&px=Linux-5.6-Spectacular)


<br>

## Chapter 4, Writing your first Kernel Module-LKMs Part 1 - Further Reading

- [Official Kernel Documentation : kernel parameters](https://www.kernel.org/doc/html/latest/admin-guide/kernel-parameters.html)
- ['How to get printk format specifiers right', Linux kernel doc](https://www.kernel.org/doc/html/latest/core-api/printk-formats.html?highlight=dma)
- ['What are the __init* and __exit* macros ?', kernelnewbies](https://kernelnewbies.org/FAQ/InitExitMacros)
- Systemd
	-   Article: ['Systemd Essentials: Working with Services, Units, and the Journal', DigitalOcean](https://www.digitalocean.com/community/tutorials/systemd-essentials-working-with-services-units-and-the-journal)
	- Article: ['Understanding Systemd Units and Unit Files', DigitalOcean](https://www.digitalocean.com/community/tutorials/understanding-systemd-units-and-unit-files) 
	- [Systemd Documentation](http://0pointer.de/blog/projects/systemd-docs.html)
	- [Systemd FAQs](https://www.freedesktop.org/wiki/Software/systemd/FrequentlyAskedQuestions/)
- [Linux console (on Wikipedia)](https://en.wikipedia.org/wiki/Linux_console)
- [Debugging by printing, eLinux](https://elinux.org/Debugging_by_printing)
- Blog article: ["MAKEFILES TUTORIAL", Liran B.H.](http://devarea.com/makefiles-tutorial/)
- Blog article: [A Standalone Linux Kernel Module, Levinzon, Medium, May 2020](https://medium.com/@eitan.levinzon/a-standalone-linux-kernel-module-df54283d4803)
- [BusyBox: The Swiss Army Knife of Embedded Linux](https://www.busybox.net/)


<br>

## Chapter 5, Writing your first Kernel Module-LKMs Part 2 - Further Reading

- Blog article: [WORKING ON THE CONSOLE WITH THE RASPBERRY PI, kaiwanTECH](https://kaiwantech.wordpress.com/2018/12/16/working-on-the-console-with-the-raspberry-pi/)

- Licensing
    - [Being honest with MODULE_LICENSE, Jon Corbet, LWN, Apr 2004](https://lwn.net/Articles/82305/)
    - [Multi-licensing](https://en.wikipedia.org/wiki/Multi-licensing)
    - [Dual Licensing: Having Your Cake and Eating It Too](https://www.linuxinsider.com/story/38172.html), LinuxInsider
    - [GPL License FAQs](https://www.gnu.org/licenses/gpl-faq.html)
    - Selecting a license
        - [Open Source Licenses Comparison -Guide](https://itsfoss.com/open-source-licenses-explained/), Leroux, Nov 2019
        - [Choose an open source license](https://choosealicense.com/)
            - [Appendix; a convenient comparison table of OSS licenses](https://choosealicense.com/appendix/)

- Arithmetic Overflow
    - An excellent must-read whitepaper: ['Understanding Integer Overflow in C/C++', Dietz, et al, June 2012](http://www.cs.utah.edu/~regehr/papers/overflow12.pdf)
    - ['Catch and compute overflow during multiplication of two large integers', StackOverflow](https://stackoverflow.com/questions/1815367/catch-and-compute-overflow-during-multiplication-of-two-large-integers)
    - An example of checking for arithmetic overflow in 'real-world' code can be found [in the git codebase](https://github.com/git/git); see the [wrapper.c code](https://github.com/git/git/blob/master/wrapper.c) for usage examples
- Article: ['Improving EXPORT_SYMBOL()', Jon Corbet, Feb 2016, LWN](https://lwn.net/Articles/674303/)

- StackOverflow Q&A: ["How to prevent “error: 'symbol' undeclared here” despite EXPORT_SYMBOL in a Linux kernel module?"](https://stackoverflow.com/questions/6670589/how-to-prevent-error-symbol-undeclared-here-despite-export-symbol-in-a-linu?noredirect=1&lq=1)
- Linux kernel static analysis
	- Blog article: ["Static analysis on the Linux kernel"](http://smackerelofopinion.blogspot.com/2017/09/static-analysis-on-linux-kernel.html)
	- PDF: ["Static code checking In the Linux kernel", Arnd Bergmann, Linaro](https://elinux.org/images/d/d3/Bargmann.pdf)
	- Thesis paper: ["Automatic Bug-finding Techniques for Large Software Projects", Jiri Slaby](https://www.fi.muni.cz/~xslaby/sklad/dis.pdf)
- A book on static analysis with the opensource SonarQube tool: ['SonarQube in Action', G. Ann Campbell and Patroklos P. Papapetrou, Oct 2013] https://www.manning.com/books/sonarqube-in-action#toc

- Blog article: ["LINUX KERNEL DEVELOPMENT – KERNEL MODULE PARAMETERS", Liran B.H.](http://devarea.com/linux-kernel-development-kernel-module-parameters/)
- Useful Arch Linux Wiki on kernel module - gathering info, auto-loading, aliasing, blacklisting, etc: ["Kernel module"](https://wiki.archlinux.org/index.php/Kernel_module)
- StackOverflow Q&A: ["Where does modprobe load a driver that udev requests?"](https://unix.stackexchange.com/questions/330186/where-does-modprobe-load-a-driver-that-udev-requests)
- DKMS: Dynamic Kernel Module Support
	- AskUbuntu: ["What does DKMS do? How do I use it?"](https://askubuntu.com/questions/408605/what-does-dkms-do-how-do-i-use-it)
	- dkms(8) man page](https://linux.die.net/man/8/dkms)

- [Linux Kernel Security](https://github.com/PacktPublishing/Linux-Kernel-Programming/blob/master/Further_Reading.md#kernel_sec)
	- The [Kernel Self Protection Project](https://kernsec.org/wiki/index.php/Kernel_Self_Protection_Project)  (KSPP, Kees Cook)
	- Regular updates on the state of kernel secuirty: [codeblog, by Kees Cook](https://outflux.net/blog/)
	- Arch Linux wiki: ["Security / Kernel hardening"](https://wiki.archlinux.org/index.php/security#Kernel_hardening)
	- ["The status of kernel hardening", LWN, Nov 2016](https://lwn.net/Articles/705262/)
	- Blog article: ["Effectively bypassing kptr_restrict on Android"](http://bits-please.blogspot.com/2015/08/effectively-bypassing-kptrrestrict-on.html)
	- Quora: ["What are some of the best resources for Kernel exploitation on Linux?"](https://www.quora.com/What-are-some-of-the-best-resources-for-Kernel-exploitation-on-Linux/answer/Kaiwan-N-Billimoria)
	- [Linux Kernel Exploitation GitHub blog - a long list of kernel exploitation resources](https://github.com/xairy/linux-kernel-exploitation)
	- ["Hardened GNU/Linux - Linux kernel mitigation checklist"](https://hardenedlinux.github.io/system-security/2016/12/13/kernel_mitigation_checklist.html)
	- ["Loading signed kernel modules", LWN, Dec 2011](https://lwn.net/Articles/470906/)
    - ["Is My IoT Device Secure? 7 Questions You Should Be Asking Yourself Today", Jan 2020, DZone](https://dzone.com/articles/is-my-iot-device-secure-7-questions-you-should-be)

- [The Eudyptula Challenge](http://eudyptula-challenge.org/): "The Eudyptula Challenge was a series of programming exercises for the Linux kernel, that started from a very basic "Hello world" kernel module, moving on up in complexity to getting patches accepted into the main Linux kernel source tree." It's really cool but NOT active as of this writing though.

<br>

## Chapter 6, Kernel Internals Essentials - Processes and Threads - Further Reading
- Book: [Hands-On System Programming with Linux", Kaiwan N Billimoria, Packt](https://www.packtpub.com/networking-and-servers/hands-system-programming-linux). Prerequisites to this chapter (essential reading, really):
	- Ch 1 : Linux System Architecture
	- Ch 2 : Virtual Memory
- CPU ABI, a blog article : [APPLICATION BINARY INTERFACE (ABI) DOCS AND THEIR MEANING](https://kaiwantech.wordpress.com/2018/05/07/application-binary-interface-abi-docs-and-their-meaning/)

- [LWN kernel index on kernel stacks](https://lwn.net/Kernel/Index/#Kernel_ stack)

- Blog article: [Some Tricks used by the Linux kernel](https://geeksww.com/tutorials/operating_systems/linux/tips_and_tricks/some_tricks_used_by_the_linux_kernel.php)
- [un]likely() macros:
	- [likely()/unlikely() macros in the Linux kernel - how do they work? What's their benefit?](https://stackoverflow.com/questions/109710/likely-unlikely-macros-in-the-linux-kernel-how-do-they-work-whats-their)
	- [Why do we use __builtin_expect when a straightforward way is to use if-else](https://stackoverflow.com/questions/7346929/why-do-we-use-builtin-expect-when-a-straightforward-way-is-to-use-if-else)

- [e]BPF – The modern approach to system/app tracing and performance analysis:
    - [Linux Extended BPF (eBPF) Tracing Tools, Brendan Gregg](http://www.brendangregg.com/ebpf.html)
    - [Learn eBPF Tracing: Tutorial and Examples (B Gregg)](http://www.brendangregg.com/blog/2019-01-01/learnebpf-tracing.html)
    - [How eBPF Turns Linux into a Programmable Kernel, Jackson, October 2020](https://thenewstack.io/how-ebpf-turnslinux-into-a-programmable-kernel/)
    - (Kernel-level) [A thorough introduction to eBPF, Matt Fleming, LWN, December 2017](https://lwn.net/Articles/740157/)
    - [How io_uring and eBPF Will Revolutionize Programming in Linux, Glauber Costa, April 2020](https://thenewstack.io/how-io_uring-and-ebpf-will-revolutionizeprogramming-in-linux/)
    - [BPF Performance Tools, by Brendan Gregg – official repo](https://github.com/brendangregg/bpf-perf-tools-book)

- Kernel lockdown:
    - [Linux Kernel Finally Gets Its Lockdown, J Wallen, October 2019](https://thenewstack.io/linux-kernel-finally-gets-its-lockdown/)
    - [Lockdown as a security module, Jonathan Corbet, LWN, June 2019](https://lwn.net/Articles/791863/)
    - [Running an eBPF program may require lifting the kernel lockdown, Gehrcke, September 2019](https://gehrcke.de/2019/09/running-an-ebpf-program-may-require-liftingthe-kernel-lockdown/)


<br>

## Chapter 7, Memory Management Internals Essentials - Further Reading
- Books on Linux kernel memory management internals:
	- ['Professional Linux Kernel Architecture', Mauerer, Wrox Press](https://www.amazon.in/Professional-Linux-Kernel-Architecture-Programmer/dp/0470343435/ref=sr_1_1?ie=UTF8&qid=1547525512&sr=8-1&keywords=Professional%20Linux%20Kernel%20Architecture%27)
	- ['Understanding the Linux Virtual Memory Manager', Mel Gorman (Bruce Perens Open Source)](https://www.amazon.in/Understanding-Virtual-Memory-Manager-Perens/dp/0131453483/ref=sr_1_1?ie=UTF8&qid=1547529951&sr=8-1&keywords=mel%20gorman)

- [x86 Paging Tutorial, C Santilli](https://cirosantilli.com/x86-paging)
- Deep detail on MM and paging on the Intel processors can be found in their excellent manuals here (Ch 4, Paging): [Intel® 64 and IA-32 Architectures
Software Developer’s Manual. Volume 3 (3A, 3B & 3C): System Programming Guide](https://software.intel.com/en-us/download/intel-64-and-ia-32-architectures-sdm-combined-volumes-3a-3b-3c-and-3d-system-programming-guide)
	- [All Intel 64 and IA-32 architecture and programming environment manuals](https://software.intel.com/en-us/articles/intel-sdm)

- On vsyscall, vdso and VVAR
    - ["On vsyscalls and the vDSO"](https://lwn.net/Articles/446528/), LWN, Jon Corbet, June 2011
    - ["Are system calls the only way to interact with the Linux kernel from user land?", StackExchange, Apr 2014](https://unix.stackexchange.com/questions/124928/are-system-calls-the-only-way-to-interact-with-the-linux-kernel-from-user-land)

- ['Linux Terminal: Check who uses all your memory with smem', Linuxaria, Oct 2013](https://linuxaria.com/pills/linux-terminal-check-who-uses-all-your-memory-with-smem)

- Kernel memory optimization techniques
	- [THP (Transparent Huge Pages)](https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge)
	- [KSM (Kernel Samepage Merging)](https://www.kernel.org/doc/html/latest/admin-guide/mm/ksm.html)
- ['Virtual Memory and Linux', PDF, Matt Porter, Alan Ott](https://elinux.org/images/b/b0/Introduction_to_Memory_Management_in_Linux.pdf)

<br>

## Chapter 8, Kernel Memory Allocation for Module Authors, Part 1 - Further Reading

- Book: ['Hands-On System Programming with Linux', Kaiwan N Billimoria, Packt](https://www.packtpub.com/networking-and-servers/hands-system-programming-linux). Prerequisites to this chapter (essential reading, really):
	- Ch 1 : Linux System Architecture
	- Ch 2 : Virtual Memory
- [Linux kernel documentation on memory management](https://www.kernel.org/doc/html/latest/core-api/index.html#memory-management)

- Information regarding GFP flags internal usage, etc: ['Memory management when failure is not an option', LWN, Mar 2015](https://lwn.net/Articles/635354/)

- CPU Caches
    - ["How L1 and L2 CPU Caches Work, and Why They’re an Essential Part of Modern Chips", Joel Hruska, Aug 2018](http://www.extremetech.com/extreme/188776-how-l1-and-l2-cpu-caches-work-and-why-theyre-an-essential-part-of-modern-chips)
    - An example diagram of CPU (cache) hierarchy: ["Memory hierarchy of an AMD Bulldozer server"](https://en.wikipedia.org/wiki/CPU_cache#/media/File:Hwloc.png)

- Slab layer - performance, etc
    -   ['Toward a more efficient slab allocator', LWN, Jon Corbet, Jan 2015](https://lwn.net/Articles/629152/)
    -   Blog article ['INTERESTING NUMBERS'](https://kaiwantech.wordpress.com/2015/05/01/interesting-numbers/); see the section on *Networking* for some information on how the network subsystem has time critical code paths (and the resource links that follow)

- ["GNUPLOT 4.2 - A Brief Manual and Tutorial", Duke University](https://people.duke.edu/~hpgavin/gnuplot.html)
- ['Object-oriented design patterns in the kernel, part 1', Neil Brown, LWN, June 2011](https://lwn.net/Articles/444910/)


<br>

## Chapter 9, Kernel Memory Allocation for Module Authors, Part 2 - Further Reading

- [LWN kernel index on memory management](https://lwn.net/Kernel/Index/#Memory_management)

- ['kvmalloc()', Jon Corbet, LWN, Jan 2017](https://lwn.net/Articles/711653/)
- ['The "too small to fail" memory-allocation rule', Jon Corbet, LWN, Dec 2014](https://lwn.net/Articles/627419/)
- Blog article: ['linux slab poisoning 101', Mar 2009](http://www.chizang.net/alex/2009/03/11/linux-slab-poisoning-101/)
- ['The slab and protected-memory allocators', LWN, May 2018](https://lwn.net/Articles/753154/)

- Kernel memory debugging tools and techniques:
    - [KASAN – Kernel Address Sanitizer](https://www.kernel.org/doc/html/latest/dev-tools/kasan.html)
    - [Kernel SLUB debug](https://www.kernel.org/doc/Documentation/vm/slub.txt)
    - [kmemleak](https://www.kernel.org/doc/html/latest/dev-tools/kmemleak.html)

- DMA - Direct Memory Access
    - Books: 'Essential Linux Device Drivers', S Venkateswaran, and 'Linux Device Drivers', Rubini, Corbet & Hartman
    - ['DMAEngine documentation', Linux kernel](https://www.kernel.org/doc/html/latest/driver-api/dmaengine/index.html#dmaengine-documentation)
    - ['A deep dive into CMA', LWN, Mar 2012](https://lwn.net/Articles/486301/)
    - A quite simple and interesting example of a “DMA test application” device driver is from Xilinx (for it's Zynq PL330 DMA controller); [wiki page here](http://www.wiki.xilinx.com/Zynq+Linux+pl330+DMA)
    - [Q&A on SO: Linux DMA: Using the DMAengine for scatter-gather transactions, May 2016](http://stackoverflow.com/questions/37119332/linux-dma-using-the-dmaengine-for-scatter-gather-transactions)


- OOM and VM Overcommit
    - [Toward more predictable and reliable out-of-memory handling, LWN, Jon Corbet, December 2015](https://lwn.net/
Articles/668126/)
    - [Quora: What are the disadvantages of disabling memory overcommit in Linux?](https://www.quora.com/What-are-the-disadvantages-of-disabling-memory-overcommit-in-Linux)
    - [Relevant Linux kernel documentation](https://www.kernel.org/doc/Documentation/vm/overcommit-accounting)
    - Blog article: ['Virtual memory settings in Linux - The Problem with Overcommit'](http://engineering.pivotal.io/post/virtual_memory_settings_in_linux_-_the_problem_with_overcommit/)
    - RHEL specific but useful: ['Interpreting /proc/meminfo and free output for Red Hat Enterprise Linux 5, 6 and 7'](https://access.redhat.com/solutions/406773)
    - [Blog article: Surviving the Linux OOM Killer, October 2018](https://dev.to/rrampage/surviving-the-linux-oomkiller-2ki9)

- [StackOverflow: How to mmap a Linux kernel buffer to userspace?](https://stackoverflow.com/a/10770582/779269)


<br>

## Chapter 10, The CPU Scheduler, Part 1 - Further Reading

- Detailed PDF: ['A complete guide to Linux process scheduling', Nikita Ishkov, Feb 2015](https://trepo.tuni.fi/bitstream/handle/10024/96864/GRADU-1428493916.pdf)
- An excellent detailed code-level article on how very particularly the context switching code path switch_to() has evolved on the x86[_64] arch: ['Evolution of the x86 context switch in Linux', Maizure, Sept 2018](https://www.maizure.org/projects/evolution_x86_context_switch_linux/)

- perf:
   - [Linux perf examples, Brendan Gregg](http://www.brendangregg.com/perf.html)
   - [The perf wiki page](https://perf.wiki.kernel.org/index.php/Main_ Page)
   - [perf tutorial](https://perf.wiki.kernel.org/index.php/)
   - Tutorial: [Playing around with perf](https://www.bernardi.cloud/2012/08/07/playing-around-with-perf/)
   - [Memory Access Patterns Are Important](https://mechanical-sympathy.blogspot.com/2012/08/memoryaccess-patterns- are-important.html)

- [Tuning the Task Scheduler, SuSe documentation](https://documentation.suse.com/sles/12-SP4/html/SLES-all/cha-tuning-taskscheduler.html)
- [A real-world, useful case: Reducing latency spikes by tuning the CPU scheduler, T Gabriec, June 2016, Scylla]( https://www.scylladb.com/2016/06/10/read-latency-and-scylla-jmx-process/)
- [Linux kernel preemption and the latency-throughput tradeoff, Dec 2019](https://www.codeblueprint.co.uk/2019/12/23/linuxpreemption-latency-throughput.html)
- An excellent detailed code-level article on how, specifically, the context switching switch_to() code path has evolved on the x86[_64] arch: [Evolution of the x86 context switch in Linux, Maizure, September 2018](https://www.maizure.org/projects/evolution_x86_context_switch_linux/)


<br>

## Chapter 11, The CPU Scheduler, Part 2 - Further Reading


- Ftrace
    - ['ftrace: trace your kernel functions!', Julia Evans, Mar 2017](https://jvns.ca/blog/2017/03/19/getting-started-with-ftrace/)

- Control Groups (cgroups)
    - Good introductory article (focussed on cgroups1): ['Control Groups in Linux', Feb 2017](http://blog.brew.com.hk/control-groups-in-linux/)
    - ['Understanding the new control groups API', Rami Rosen, LWN, Mar 2016](https://lwn.net/Articles/679786/)
    - ['Control Group v2' : Linux kernel 'official' documentation](https://www.kernel.org/doc/html/latest/admin-guide/cgroup-v2.html#control-group-v2)
    - man page (informational): ['cgroups - Linux control groups'](http://man7.org/linux/man-pages/man7/cgroups.7.html) (man 7 cgroups)
    - RedHat System Design Guide (RHEL 8); focus on cgroups v1: ['SETTING LIMITS FOR APPLICATIONS'](https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/8/html/system_design_guide/setting-limits-for-applications_system-design-guide)
    - FB: Includes an interesting case study on how Facebook uses Linux's cgroups2 to perform equitable resource distribution on (some of) it's servers: ['Maximizing Resource Utilization with cgroup2'](https://facebookmicrosites.github.io/cgroup2/docs/overview.html)
        - ['Creating and organizing cgroups'](https://facebookmicrosites.github.io/cgroup2/docs/create-cgroups.html)
    - Blog article, examples of using cgroups v1 for CPU and memory bandwidth control: ['Linux Virtualization : Resource throttling using cgroups'](https://www.geeksforgeeks.org/linux-virtualization-resource-throttling-using-cgroups/)

- Hard Real-Time and Linux as an RTOS
    - ['Inside Real-Time Linux', Feb 2017](https://www.linux.com/news/event/elce/2017/2/inside-real-time-linux)
    - ['The Road to Real Time Linux', Steven Rostedt, Mar 2017](https://blogs.vmware.com/opensource/2017/03/16/road-real-time-linux/)
    - [VDC Survey on real-time response : The Embedded Muse, 341, 03 Jan 2018, Jack Ganssle](http://www.ganssle.com/tem/tem341.html#article3)
    - Blog article: ['Algorithm time complexity and big O notation'](https://medium.com/@StueyGK/algorithm-time-complexity-and-big-o-notation-51502e612b4d)
    - Book: *Automate This: How Algorithms Came to Rule Our World, Christopher Steiner*
    - Older wiki site on *preempt_rt*; it's in the process of being migrated to the new documentation for RTL; it still has very useful HOWTO guides, articles, etc: ['Real-Time Linux Wiki'](https://rt.wiki.kernel.org/index.php/Main_Page)

- RTL – Real-Time Linux, using Linux as an RTOS:
    - [The RTL Collaborative Project](https://wiki.linuxfoundation.org/realtime/rtl/start)
    - [RTL Real-Time documentation](https://wiki.linuxfoundation.org/realtime/documentation/start)
    - [HOWTO: RTOS and RT Applications](https://wiki.linuxfoundation.org/realtime/documentation/howto/applications/application_base)
    - Interesting: "... compares the load results of the Ubuntu 18.04 LTS generic kernel 4.15.0-22-generic, the Ubuntu low-latency kernel 4.15.0-22-lowlatency and an Ubuntu Linux kernel patched to be fully preemptive 4.16.0-rt4-PREEMPT_RT_FULL as well as preemptive with low-latency 4.16.12-rt4+REEMPT_LL" : ['Low latency and real-time kernels for telco and NFV', Ubuntu, Oct 2018](https://ubuntu.com/blog/low-latency-real-time-kernels-telco-nfv)
    - ['Real-time Linux communications - An evaluation of the Linux communication stack for real-time robotic applications', Sept 2018](https://hackernoon.com/real-time-linux-communications-2faabf31cf5e)
    - ['The real-time linux kernel: A survey on Preempt_RT', Feb 2019](https://www.researchgate.net/publication/331290349_The_real-time_linux_kernel_A_survey_on_Preempt_RT)
    - Detailed slides on cyclictest, good for understanding latency and it's measurement: ['Using and Understanding the Real-Time Cyclictest Benchmark', Rowand, Oct 2013](https://events.static.linuxfound.org/sites/events/files/slides/cyclictest.pdf)
    - ['Intro to Real-Time Linux for Embedded Developers', an interview with Steven Rostedt](https://www.linuxfoundation.org/blog/2013/03/intro-to-real-time-linux-for-embedded-developers/)

- [e]BPF tools for measuring scheduler / runqueue latencies (plus other stuff):
    - [Very useful summary diagram of Linux [e]BPF tracing tools, Brendan Gregg](http://www.brendangregg.com/BPF/bcc_tracing_tools_early2019.png)
    - [Linux Extended BPF (eBPF) Tracing Tools, Brendan Gregg](http://www.brendangregg.com/ebpf.html)
    - [BPF Compiler Collection (BPFCC) on GitHub](https://github.com/iovisor/bcc)

- The still amazing and very relevant book on software engineering: *'The Mythical Man Month: Essays on Software Engineering'*, Frederick P Brooks, 1975, 1995
    - [On Amazon (Anniversary Edition)](https://www.amazon.com/Mythical-Man-Month-Anniversary-Software-Engineering-ebook/dp/B00B8USS14/ref=sr_1_1?crid=3R2CNHTX5LYIC&keywords=mythical+man+month&qid=1562226712&s=digital-text&sprefix=mythical+%2Cdigital-text%2C376&sr=1-1)
    - [Quotes](https://en.wikiquote.org/wiki/Fred_Brooks)


<br>

## Chapter 12, Kernel Synchronization, Part 1 - Further Reading

- An excellent read: ['What every systems programmer should know about concurrency', M Kline, May 2018](https://assets.bitbashing.io/papers/concurrency-primer.pdf)

- Chip Overclock blog: [Peeking under the Hood, Sloan, May 2012](https://coverclock.blogspot.com/2012/05/peeking-under-hood.html)
- [Measuring context switching and memory overheads for Linux threads, Eli Bendersky, Sept 2018](https://eli.thegreenplace.net/2018/measuring-context-switching-and-memory-overheads-for-linux-threads/)
- Compiler Explorer website, Matt Godbolt; very useful: [See the live disassembly of your code on a large choice of compilers and compiler flags](https://godbolt.org/)

- This presentation covers deadlock scenarios: ['Lockdep: how to read it's cryptic output', Steve Rostedt, Linux Plumbers Conf 2011](https://blog.linuxplumbersconf.org/2011/ocw/sessions/153)

-  ['Mutexes and Semaphores Demystified', Micheal Barr, May 2016](https://barrgroup.com/Embedded-Systems/How-To/RTOS-Mutex-Semaphore)


- The Mars Pathfinder mission and Priority Inversion
	- ['What really happened on Mars ?' Glenn Reeves](https://cs.unc.edu/~anderson/teach/comp790/papers/mars_pathfinder_long_version.html)
	- A must-read (PDF): [*What the Media Couldn't Tell You About Mars Pathfinder*](http://people.cs.ksu.edu/~hatcliff/842/Docs/Course-Overview/pathfinder-robotmag.pdf)
	- Detailed paper (PDF): [*Mars Pathfinder: Priority Inversion Problem*, R.M. Pathan](http://www.cse.chalmers.se/edu/year/2015/course/EDA222/Documents/Misc/Report_MarsPathFinder.pdf)
	- More recently (May 2015), with respect to the NASA Curiosity Rover: [*13 engineering truths proved by NASA's Curiosity Rover*, EDN](https://www.edn.com/electronics-blogs/now-hear-this/4439386/13-engineering-truths-proved-by-NASA-s-CuriosityRover?mc=NL_EDN_EDT_EDN_funfriday_20150508&cid=NL_EDN_EDT_EDN_funfriday_20150508&elq=75871e4437784010b51f12e4c3be00a2&elqCampaignId=22919&elqaid=25798&elqat=1&elqTrackId=8e848e14bf3e41b58e660c804b335b07)

 - OSFY magazine: ['How to Avoid Priority Inversion and Enable Priority Inheritance in Linux Kernel Programming', Thangaraju & Warade, Apr 2019](https://opensourceforu.com/2019/04/how-to-avoid-priority-inversion-and-enable-priority-inheritance-in-linux-kernel-programming/)
 - Spinlock internal implementation
    - ['Peeking Under the Hood', John Sloan, Chip Overclock blog, May 2012](https://coverclock.blogspot.com/2012/05/peeking-under-hood.html)
    - ['spin_lock implementation in ARM linux', linuxforthenew blog, Apr 2013](http://linuxforthenew.blogspot.com/2013/04/spinlock-implementation-in-arm-linux.html)


<br>

## Chapter 13, Kernel Synchronization, Part 2 - Further Reading

- Deeper details on the LKMM: [Explanation of the Linux-Kernel Memory Model](https://github.com/aparri/memory-model/ blob/master/Documentation/explanation. txt)
- Reference Counting API: [kernsec: a summary](https://kernsec.org/wiki/index.php/Kernel_ Protections/refcount_ t)

- An extremely detailed take on concurrency topics, both hardware and software-wise: [Is Parallel Programming Hard, And, If So, What Can You Do About It?, Paul E.McKenney, December 2019](https://mirrors.edge.kernel.org/pub/linux/kernel/people/paulmck/perfbook/perfbook.2019.12.22a.pdf)

- False Sharing
    - ['Avoiding and Identifying False Sharing Among Threads', Intel, Nov 2011](https://software.intel.com/en-us/articles/avoiding-and-identifying-false-sharing-among-threads)
    - Blog article: ['Understanding False Sharing', Mar 2017](https://parallelcomputing2017.wordpress.com/2017/03/17/understanding-false-sharing/)


- Per-CPU variables:
    - Blog article: [A brief introduction to per-cpu variables, Chen, May 2014](http://thinkiii.blogspot.com/2014/05/a-briefintroduction-to-per-cpu.html)
    - [How are percpu pointers implemented in the Linux kernel?, Stack Overflow, June 2013](https://stackoverflow.com/questions/16978959/how-are-percpu-pointersimplemented-in-the-linux-kernel)


- Lock-free (or lockless) programming:
    - [What every systems programmer should know about concurrency, Matt Kline, May 2018](https://assets.bitbashing.io/papers/concurrency-primer.pdf)
    - Excellent "lock-free 101" articles:
        - [Fear and Loathing in Lock-Free Programming, T. Neely, Medium](https://medium.com/@tylerneely/fear-and-loathing-in-lock-freeprogramming-7158b1cdd50c)
        - [An Introduction to Lock-Free Programming, Preshing on Programming blog, June 2012](https://preshing.com/20120612/an-introduction-to-lock-free-programming/)
    - Good article series: ['Introduction to Lock-free Algorithms'](http://www.1024cores.net/home/lock-free-algorithms/introduction)
        - Presentation: ['Lock-Free Programming', Geoff Langdale](https://www.cs.cmu.edu/~410-s05/lectures/L31_LockFree.pdf)
        - Blog article: ['Some notes on lock-free and wait-free algorithms'](http://www.rossbencina.com/code/lockfree?q=~rossb/code/lockfree/)
        - ['CppCon 2014: Herb Sutter "Lock-Free Programming (or, Juggling Razor Blades), Part I', Herb Sutter, YouTube video](https://www.youtube.com/watch?v=c1gO9aB9nbs)


- kdump and crash:
    - Kernel documentation for kdump: [The kexec-based Crash Dumping Solution](https://www.kernel.org/doc/ocumentation/kdump/kdump.txt)
    - [Oops! Debugging Kernel Panics, Linux Journal, August 2019](https://www.linuxjournal.com/content/oopsdebugging-kernel-panics-0)
    - Excellent resource for learning and using the crash app: [White paper: Red Hat Crash Utility, David Anderson](https://crash-utility.github.io/crash_ whitepaper.html)
    - [Analyzing Linux kernel crash dumps with crash - The one tutorial that has it all, Dedoimedo, June 2010]( http://www.dedoimedo.com/computers/crash-analyze.html)

- Memory barriers:
    - PDF: ['Memory Barriers: a Hardware View for Software Hackers',
Paul E. McKenney, IBM LTC, June 2010](http://www.rdrop.com/~paulmck/scalability/paper/whymb.2010.06.07c.pdf)
    - [Memory Barriers Are Like Source Control Operations, Preshing on Programming blog, July 2012](https://preshing.com/20120710/memory-barriers-are-like-source-control-operations/)

- Lockdep
        - ['Runtime locking correctness validator', kernel documentation](https://www.kernel.org/doc/Documentation/locking/lockdep-design.txt)
        - ['The kernel lock validator', LWN, J Corbet, May 2006](https://lwn.net/Articles/185666/)
        - ['Lockdep: how to read it's cryptic output', Steve Rostedt, Linux Plumbers Conf 2011](https://blog.linuxplumbersconf.org/2011/ocw/sessions/153)
        - ['LOCKDEP, AN INSIDE OUT PERSPECTIVE', Nahim El Atmani, Nov 2016](https://www.lse.epita.fr/data/lt/2016-11-08/lt-2016-11-08-Nahim_El_Atmani-lockdep-an-inside-out-perspective.pdf)
        - (until it gets merged :-) : ['[PATCH 16/28] locking/lockdep: Add explanation to lock usage rules in lockdep design doc', Yuyang Du](https://lkml.org/lkml/2019/4/24/333), Apr 2019


- RCU in the Linux kernel
    - The excellent and extensive kernel community documentation: [RCU](https://www.kernel.org/doc/Documentation/RCU/00-INDEX)
    - [My First Kernel Module: A Debugging Nightmare, Ryan Eberhardt. Nov 2020](https://reberhardt.com/blog/2020/11/18/my-first-kernel-module.html); see the section entitled 'RCU: Read, Copy, Update', excellent and clear!
    - ['RCU Usage In the Linux Kernel: One Decade Later', McKenny et al (PDF), circa 2013](http://www2.rdrop.com/~paulmck/techreports/RCUUsage.2013.02.24a.pdf)
    - A 3 series article to learn RCU: ['What is RCU, Fundamentally?', LWN, Paul McKenney, Dec 2007, Part 1 of 3 ](https://lwn.net/Articles/262464/)
    - ['Make any algorithm lock-free with this one crazy trick', May 2016](https://www.the-paper-trail.org/post/2016-05-25-make-any-algorithm-lock-free-with-this-one-crazy-trick/)
    - ['The lockless page cache', LWN, Jon Corbet, July 2008](https://lwn.net/Articles/291826/) (an interesting article)



[\[Top\]](https://github.com/PacktPublishing/Linux-Kernel-Programming/blob/master/Further_Reading.md#further-reading)


[End Doc]
