


# Linux System Programming Techniques

<a href="https://www.packtpub.com/product/linux-system-programming-techniques/9781789951288#:~:text=About%20this%20book&text=It%20enables%20you%20to%20extend,pages%2C%20and%20Linux%20system%20calls.?utm_source=github&utm_medium=repository&utm_campaign=9781789951288"><img src="https://static.packt-cdn.com/products/9781789951288/cover/smaller" alt="Linux System Programming Techniques" height="256px" align="right"></a>

This is the code repository for [Linux System Programming Techniques](https://www.packtpub.com/product/linux-system-programming-techniques/9781789951288#:~:text=About%20this%20book&text=It%20enables%20you%20to%20extend,pages%2C%20and%20Linux%20system%20calls.?utm_source=github&utm_medium=repository&utm_campaign=9781789951288), published by Packt.

**Linux System Programming Techniques,  published by Packt**

## Errata
An up-to-date errata can be found [here](errata.md). Please review this document if you encounter any problems!

## What is this book about?
Linux is the world's most popular open-source operating system. Linux system programming is all about developing system programs for Linux and Unix operating systems. 
It enables you to extend the Linux operating system with your own system programs and to communicate with other programs on the system. The book begins by exploring the GCC compiler, a C program, the shell, the built-in manual pages, and Linux system calls.
This book covers the following exciting features:
* Discover how to write programs for the Linux system using a wide variety of system calls
* Delve into the working of POSIX functions
* Understand and use key concepts such as signals, pipes, IPC, and process management
* Find out how to integrate programs with a Linux system
* Explore advanced topics such as filesystem operations, creating shared libraries, and debugging your programs
* Gain an overall understanding of how to debug your programs using Valgrind

If you feel this book is for you, get your [copy](https://www.amazon.com/dp/1789951283) today!

<a href="https://www.packtpub.com/?utm_source=github&utm_medium=banner&utm_campaign=GitHubBanner"><img src="https://raw.githubusercontent.com/PacktPublishing/GitHub/master/GitHub.png" 
alt="https://www.packtpub.com/" border="5" /></a>

## Instructions and Navigations
All of the code is organized into folders. For example, Chapter02.

The code will look like the following:
```
#include <stdio.h>
int main(void)
{
    printf("Hello, world!\n");
    return 0;
}
```

### Code in Action
Click on following link to see the Code in Action:

[Youtube link](https://bit.ly/39ovGd6)

**Following is what you need for this book:**
This book is for anyone who wants to develop system programs for Linux and gain a deeper understanding of the Linux system. The book is beneficial for anyone who is facing issues related to a particular part of Linux system programming and is looking for specific recipes or solutions.

With the following software and hardware list you can run all code files present in the book (Chapter 1-12).

We also provide a PDF file that has color images of the screenshots/diagrams used in this book. [Click here to download it](http://www.packtpub.com/sites/default/files/downloads/9781789951288_ColorImages.pdf).

### Related products
* Mastering Linux Device Driver Development [[Packt]](https://www.packtpub.com/product/mastering-linux-device-driver-development/9781789342048?utm_source=github&utm_medium=repository&utm_campaign=9781789342048) [[Amazon]](https://www.amazon.in/Mastering-Linux-Device-Driver-Development-ebook/dp/B08M6G6Q4N)

* Linux Kernel Programming [[Packt]](https://www.packtpub.com/product/linux-kernel-programming/9781789953435?utm_source=github&utm_medium=repository&utm_campaign=9781789953435) [[Amazon]](https://www.amazon.in/Linux-Kernel-Development-Cookbook-programming-ebook/dp/B07RW915K4/ref=sr_1_2?dchild=1&keywords=Linux+Kernel+Programming&qid=1617710161&s=digital-text&sr=1-2)

## Get to Know the Author
**Jack-Benny Persson**
is a consultant and author based in Sweden. He has written several books about Linux and programming. His passion for Linux and other Unix-like systems started as a hobby more than 20 years ago. Since then, he has spent most of his spare time reading about Linux, tinkering with Linux servers, and writing about Linux administration. Today he has his own IT and media company in Sweden that focuses on Linux.
Jack-Benny holds an Advanced Higher Vocational Education Diploma as a Linux system specialist. He has also studied electronics, networking, and security.

## Other books by the authors
* [Hands-On Linux System Administration [Video]](https://www.packtpub.com/product/hands-on-linux-system-administration-video/9781789133219?utm_source=github&utm_medium=repository&utm_campaign=9781789133219)


### Download a free PDF

 <i>If you have already purchased a print or Kindle version of this book, you can get a DRM-free PDF version at no cost.<br>Simply click on the link to claim your free PDF.</i>
<p align="center"> <a href="https://packt.link/free-ebook/9781789951288">https://packt.link/free-ebook/9781789951288 </a> </p>